/////////////////////
//Crafted By Broze///
/////////////////////
using System; 
using System.Net; 
using Server; 
using Server.Accounting; 
using Server.Gumps; 
using Server.Items; 
using Server.Mobiles; 
using Server.Network; 

namespace Server.Gumps 
{ 
   public class ArtifactGump : Gump 
   { 
      private Mobile m_Mobile;
      private Item m_Deed;
 

      public ArtifactGump( Mobile from, Item deed ) : base( 30, 20 ) 
      { 
         m_Mobile = from;
	 m_Deed = deed; 
	
	 AddPage( 1 ); 

         AddBackground( 0, 0, 300, 400, 5054 ); 
         AddBackground( 8, 8, 284, 384, 3000 ); 

         AddLabel( 40, 12, 0, "Artifact List" ); 

         Account a = from.Account as Account; 


         AddLabel( 52, 40, 0, "Weapons Menu" ); 
         AddButton( 12, 40, 4005, 4007, 0, GumpButtonType.Page, 2 ); 
         AddLabel( 52, 60, 0, "Armor Menu" ); 
         AddButton( 12, 60, 4005, 4007, 0, GumpButtonType.Page, 3 ); 
         AddLabel( 52, 80, 0, "Jewelery Menu" ); 
         AddButton( 12, 80, 4005, 4007, 10, GumpButtonType.Page, 4 ); 
         AddLabel( 52, 100, 0, "Shields Menu" ); 
         AddButton( 12, 100, 4005, 4007, 0, GumpButtonType.Page, 5 );  
         AddLabel( 52, 340, 0, "Close" ); 
         AddButton( 12, 340, 4005, 4007, 0, GumpButtonType.Reply, 0 ); 
	

	 AddPage( 2 ); 

         AddBackground( 0, 0, 300, 400, 5054 ); 
         AddBackground( 8, 8, 284, 384, 3000 ); 

	 AddLabel( 40, 12, 0, "Weapons List" );
        	
          

         AddLabel( 52, 40, 0, "Bow Of Kings" ); 
         AddButton( 12, 40, 4005, 4007, 1, GumpButtonType.Reply, 1 ); 
         AddLabel( 52, 60, 0, "Halberd Of The Dead" ); 
         AddButton( 12, 60, 4005, 4007, 2, GumpButtonType.Reply, 2 ); 
         AddLabel( 52, 80, 0, "Hunters Crossbow" ); 
         AddButton( 12, 80, 4005, 4007, 3, GumpButtonType.Reply, 3 ); 
         AddLabel( 52, 100, 0, "Staff Of Tanks" ); 
         AddButton( 12, 100, 4005, 4007, 4, GumpButtonType.Reply, 4 ); 
         AddLabel( 52, 120, 0, "Barbaric Axe" ); 
         AddButton( 12, 120, 4005, 4007, 5, GumpButtonType.Reply, 5 ); 
         AddLabel( 52, 140, 0, "Leech Sword" ); 
         AddButton( 12, 140, 4005, 4007, 6, GumpButtonType.Reply, 6 ); 
         AddLabel( 52, 160, 0, "Whirlwind" ); 
         AddButton( 12, 160, 4005, 4007, 7, GumpButtonType.Reply, 7 );
	 AddLabel( 52, 180, 0, "Hammer Of Justice" );
	 AddButton( 12, 180, 4005, 4007, 8, GumpButtonType.Reply, 8 );

         AddLabel( 52, 340, 0, "Main Menu" ); 
         AddButton( 12, 340, 4005, 4007, 0, GumpButtonType.Page, 1 ); 
	

         AddPage( 3 ); 

         AddBackground( 0, 0, 300, 400, 5054 ); 
         AddBackground( 8, 8, 284, 384, 3000 ); 

         AddLabel( 40, 12, 0, "Armor List" ); 

         
         AddLabel( 52, 40, 0, "Arms Of Replentishment" ); 
         AddButton( 12, 40, 4005, 4007, 9, GumpButtonType.Reply, 1 ); 
         AddLabel( 52, 60, 0, "Leggings Of The Royal Council" ); 
         AddButton( 12, 60, 4005, 4007, 10, GumpButtonType.Reply, 2 ); 
         AddLabel( 52, 80, 0, "Tunic Of Might" ); 
         AddButton( 12, 80, 4005, 4007, 11, GumpButtonType.Reply, 3 ); 
         AddLabel( 52, 100, 0, "Gloves Of The Tiger" ); 
         AddButton( 12, 100, 4005, 4007, 12, GumpButtonType.Reply, 4 ); 
         AddLabel( 52, 120, 0, "Helm Of The Scorpion" ); 
         AddButton( 12, 120, 4005, 4007, 13, GumpButtonType.Reply, 5 ); 
         AddLabel( 52, 140, 0, "Mage Royal" ); 
         AddButton( 12, 140, 4005, 4007, 14, GumpButtonType.Reply, 6 ); 
         AddLabel( 52, 160, 0, "Touch Of Death" ); 
         AddButton( 12, 160, 4005, 4007, 15, GumpButtonType.Reply, 7 );
	 AddLabel( 52, 180, 0, "Demon Skull" ); 
         AddButton( 12, 180, 4005, 4007, 16, GumpButtonType.Reply, 8 );  

         AddLabel( 52, 340, 0, "Main Menu" ); 
         AddButton( 12, 340, 4005, 4007, 0, GumpButtonType.Page, 1 );
	 

	 AddPage( 4 ); 

         AddBackground( 0, 0, 300, 400, 5054 ); 
         AddBackground( 8, 8, 284, 384, 3000 );  

         AddLabel( 40, 12, 0, "Jewelery List" ); 

         
         AddLabel( 52, 60, 0, "Mages Brace" ); 
         AddButton( 12, 60, 4005, 4007, 17, GumpButtonType.Reply, 1 ); 
         AddLabel( 52, 100, 0, "Ring Of Stats" );
	 AddButton( 12, 100, 4005, 4007, 18, GumpButtonType.Reply, 2 ); 

         AddLabel( 52, 340, 0, "Main Menu" ); 
         AddButton( 12, 340, 4005, 4007, 0, GumpButtonType.Page, 1 );
	  

	 AddPage( 5 ); 
  
         AddBackground( 0, 0, 300, 400, 5054 ); 
         AddBackground( 8, 8, 284, 384, 3000 );

         AddLabel( 40, 12, 0, "Shields List" ); 

         

         AddLabel( 52, 40, 0, "Shield Of The Titans" ); 
         AddButton( 12, 40, 4005, 4007, 19, GumpButtonType.Reply, 1 ); 
         AddLabel( 52, 60, 0, "Shield Of Intellect" ); 
         AddButton( 12, 60, 4005, 4007, 20, GumpButtonType.Reply, 2 );  

         AddLabel( 52, 340, 0, "Main Menu" ); 
         AddButton( 12, 340, 4005, 4007, 0, GumpButtonType.Page, 1 );


      } 


      public override void OnResponse( NetState state, RelayInfo info ) 
      { 
         Mobile from = state.Mobile; 

         switch ( info.ButtonID ) 
         { 
            case 0: //Close Gump 
            { 
               from.CloseGump( typeof( ArtifactGump ) );	 
               break; 
            } 
            case 1: // Bow Of Kings 
            { 
		Item item = new BowOfKings();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            } 
            case 2: // Halberd Of The Dead 
            { 
		Item item = new HalberdOfTheDead();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            } 
            case 3: //Hunters Crossbow
            { 
		Item item = new HuntersCrossbow();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            } 
            case 4: //Staff Of Tanks 
            { 
		Item item = new StaffOfTanks();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            } 
            case 5: //Barbaric Axe 
            { 
		Item item = new BarbaricAxe();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            } 
            case 6: //Leech Sword 
            { 
		Item item = new LeechSword();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            } 
            case 7: //Whirlwind
            { 
		Item item = new Whirlwind();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }
	    case 8: //Hammer Of Justice
            { 
		Item item = new HammerOfJustice();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }    
	    case 9: //Arms Of Replentishment 
            { 
		Item item = new ArmsOfReplentishment();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            } 
	    case 10: //Leggings Of The Royal Council 
            { 
		Item item = new LeggingsOfTheRoyalCouncil();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }
 	    case 11: //Tunic Of Might 
            { 
		Item item = new TunicOfMight();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }
	    case 12: //Gloves Of The Tiger 
            { 
		Item item = new GlovesOfTheTiger();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }
	    case 13: //Helm Of The Scorpion 
            { 
		Item item = new HelmOfTheScorpion();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }
	    case 14: //Mage Royal 
            { 
		Item item = new MageRoyal();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }
	    case 15: //Touch Of Death 
            { 
		Item item = new TouchOfDeath();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }
	    case 16: //Demon Skull
            { 
		Item item = new DemonSkull();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }  
	    case 17: //Mages Brace 
            { 
		Item item = new MagesBrace();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }
	    case 18: //Ring Of Stats 
            { 
		Item item = new RingOfStats();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break;
            }
	    case 19: //Shield Of The Titans 
            { 
		Item item = new ShieldOfTheTitans();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }
	    case 20: //shield Of Intellect 
            { 
		Item item = new ShieldOfIntellect();
		item.LootType = LootType.Blessed;
		from.AddToBackpack( item ); 
		from.CloseGump( typeof( ArtifactGump ) );
		m_Deed.Delete(); 
		break; 
            }
	         
         }    
      } 
   } 
} 
